package com.bizvane.mktcenterservice.models.vo;

import java.util.Date;

import lombok.Data;

/**
 * @author zcc
 * @date 2020/12/22 10:12
 **/
@Data
public class TaskPrizeResVO {
    /**
     * pkid
     */
    @io.swagger.annotations.ApiModelProperty(value = "pkid", name = "mktTaskRecordId", required = false, example = "")
    private Long mktTaskRecordId;
    /**
     * sys_company_id
     */
    @io.swagger.annotations.ApiModelProperty(value = "", name = "sysCompanyId", required = false, example = "")
    private Long sysCompanyId;
    /**
     * 任务类型：1完善资料，2分享任务，3邀请注册，4累计消费次数，5累计消费金额.
     */
    @io.swagger.annotations.ApiModelProperty(value = "任务类型：1完善资料，2分享任务，3邀请注册，4累计消费次数，5累计消费金额，7邀请购买付费会员卡", name = "taskType", required = false, example = "")
    private Integer taskType;
    /**
     * 根据task_type对应不同任务的id
     */
    @io.swagger.annotations.ApiModelProperty(value = "根据task_type对应不同任务的id", name = "taskId", required = false, example = "")
    private Long taskId;
    /**
     * 参与任务的会员编号
     */
    @io.swagger.annotations.ApiModelProperty(value = "参与任务的会员编号", name = "memberCode", required = false, example = "")
    private String memberCode;
    /**
     * 参与任务的会员姓名
     */
    @io.swagger.annotations.ApiModelProperty(value = "参与任务的会员姓名", name = "memberName", required = false, example = "")
    private String memberName;
    /**
     * 参与任务的会员编号. member_code
     */
    @io.swagger.annotations.ApiModelProperty(value = "参与任务的会员手机号", name = "memberPhone", required = false, example = "")
    private String memberPhone;

    @io.swagger.annotations.ApiModelProperty(value = "参与任务的会员卡号", name = "memberPhone", required = false, example = "")
    private String memberCardNo;

    @io.swagger.annotations.ApiModelProperty(value = "获奖时间", name = "awardTime", required = false, example = "")
    private Date awardTime;

    @io.swagger.annotations.ApiModelProperty(value = "券数量", name = "couponNum", required = false, example = "")
    private String couponNum;

    @io.swagger.annotations.ApiModelProperty(value = "积分", name = "points", required = false, example = "")
    private Integer points;

    @io.swagger.annotations.ApiModelProperty(value = "实物奖励", name = "physicalName", required = false, example = "")
    private String physicalName;

    @io.swagger.annotations.ApiModelProperty(value = "实物提货方式：0.物流配送 1.门店自提", name = "physicalExtractionType", required = false, example = "")
    private Integer physicalExtractionType;

    @io.swagger.annotations.ApiModelProperty(value = "物流状态 0.未发货 1.已发货", name = "logisticsStatus", required = false, example = "")
    private Integer logisticsStatus;

    @io.swagger.annotations.ApiModelProperty(value = "提货状态 0.未提货 1.已提货", name = "exchangeType", required = false, example = "")
    private Integer exchangeStatus;

    @io.swagger.annotations.ApiModelProperty(value = "提货地址信息", name = "linkmanVO", required = false, example = "")
    private TaskPrizeLinkmanVO linkmanVO;

    @io.swagger.annotations.ApiModelProperty(value = "提货门店信息", name = "pickUpStoreVO", required = false, example = "")
    private PickUpStoreVO pickUpStoreVO;
}
