package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.models.bo.MktGeneralizePvRecordBo;
import com.bizvane.mktcenterservice.models.vo.MktGeneralizeVo;
import com.bizvane.mktcenterservice.models.vo.RetryMktGeneralizeChannelQrVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zcc
 * @date 2021/12/7 17:21
 **/

@FeignClient(value ="${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/generalizeRpc")
public interface MktGeneralizeChannelServiceRpc {

    /**
     * 二维码批量任务重试
     * @param retryMktGeneralizeChannelQrVo
     * @return
     */
    @PostMapping("/retryGeneralizeChannelQr")
    ResponseData<String> retryGeneralizeChannelQr(@RequestBody RetryMktGeneralizeChannelQrVo retryMktGeneralizeChannelQrVo);

    /**
     * 获取推广vo详情
     * @param mktGeneralizeId
     * @return
     */
    @GetMapping("/getGeneralizeVoById")
    ResponseData<MktGeneralizeVo> getGeneralizeVoById(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("sysBrandId") Long sysBrandId, @RequestParam("mktGeneralizeId") Long mktGeneralizeId);

    /**
     * 推广信息浏览记录新增
     * @param mktGeneralizePvRecordBo
     * @return
     */
    @PostMapping("/addQrPvRecord")
    ResponseData<String> addQrPvRecord(@RequestBody MktGeneralizePvRecordBo mktGeneralizePvRecordBo);

}
