package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.centerstageservice.models.po.SysCheckPo;
import com.bizvane.couponfacade.models.vo.CouponSendMemberListResponseVO;
import com.bizvane.couponfacade.models.vo.SendCouponSimpleRequestVO;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.messagefacade.models.vo.MemberMessageVO;
import com.bizvane.messagefacade.models.vo.SysSmsConfigVO;
import com.bizvane.mktcenterservice.models.bo.*;
import com.bizvane.mktcenterservice.models.po.MktActivityPO;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.po.MktMessagePO;
import com.bizvane.mktcenterservice.models.po.MktModifyStoreRecordPo;
import com.bizvane.mktcenterservice.models.vo.*;
import com.bizvane.mktcenterservice.models.vo.tree3.ActivityGamePrizeListReqVO;
import com.bizvane.mktcenterservice.models.vo.tree3.ActivityGamePrizeListRespVO;
import com.bizvane.mktcenterservice.models.vo.tree3.GetGameActivityListReqVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;
import org.apache.poi.ss.formula.functions.T;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author chen.li
 * @date on 2018/7/6 19:49
 * @description
 * @Copyright (c) 2018 上海商帆信息科技有限公司-版权所有
 */
public interface ActivityService {

    boolean updateActivityBizCouponList(String activityCode);

    /**
     * 禁用/停止活动
     *
     * @param vo
     * @return
     */
    public ResponseData<Integer> updateActivityById(ActivityVO vo, SysAccountPO sysAccountPO);

    /**
     * 活动审核
     *
     * @param
     * @return
     */
    public ResponseData<Integer> checkActivityById(SysCheckPo po, SysAccountPO sysAccountPO);

    /**
     * 小程序端活动列表
     *
     * @param vo
     * @return
     */
    public ResponseData<List<ActivityVO>> getActivityList(ActivityVO vo);

    public ResponseData<List<ActivityVO>> getActivityListNew(ActivityVO vo);

    /**
     * 查询效果分析统计
     *
     * @param bo
     * @return
     */
    public ResponseData<CtivityAnalysisBO> getActivityAnalysisCountpage(ActivityAnalysisCountBO bo, PageForm pageForm);

    public void sendMessage(List<MktMessagePO> messageVOList, MemberInfoModel memberInfo, ActivityVO activityVO);

    public void sendMessageWX(List<MktMessagePO> messageVOList, MemberInfoModel memberInfo, ActivityVO activityVO);

    public void sendMessageDX(List<MktMessagePO> messageVOList, MemberInfoModel memberInfo, ActivityVO activityVO);

    public void sendPoints(ActivitySmartVO vo, AwardBO awardBO, MemberInfoModel memberInfo);

    public void sendShort(MktMessagePO mktMessagePO, AwardBO awardBO, SysSmsConfigVO sysSmsConfigVO, MemberInfoModel memberInfo);

    public void sendWx(MktMessagePO mktMessagePO, AwardBO awardBO, MemberMessageVO memberMessageVO, MemberInfoModel memberInfo, ActivitySmartVO vo);

    /**
     * 同步发送微信模板消息
     * @param mktMessagePO
     * @param memberInfo
     * @param brandName
     * @param MarketingName
     * @return
     */
    public ResponseData<T> syncSendWxNew(MktMessagePO mktMessagePO, MemberInfoModel memberInfo, String brandName, String MarketingName);

    public void sendCoupon(ActivitySmartVO vo, MemberInfoModel memberInfo);

    public void sendCouponNew(ActivitySmartVO vo, AwardBO awardBO, SendCouponSimpleRequestVO sendCouponSimpleRequestVO, MemberInfoModel memberInfo);

    public void sendRegisterWx(List<MktMessagePO> messageVOList, WxChannelInfoVo wxChannelInfoVo, ActivityVO activityVO);

    public void sendDx(List<MktMessagePO> messageVOList, MemberInfoModel memberInfo,ActivityVO activityVO);

    /**
     * 活动、任务效果分析“发行优惠券”添加会员明细弹框；
     *
     * @return
     */
    ResponseData<PageInfo<CouponSendMemberListResponseVO>> findCouponSendResultActivity(Long id, Integer type, Byte sendCouponType,
                                                                                        SysAccountPO stageUser,
                                                                                        PageForm pageForm, String name, String cardNo);

    /**
     * 前端调用店铺
     */
    public List<Long> getActivityWhiteStoreIds(WhiteStoreVO vo);

    /**
     * 扫描二维码进行判断
     *
     * @param vo
     * @return
     */
    public ResponseData<Integer> judgeMember(JudgeMemberVO vo);

    /**
     * 禁用活动(通用)
     */
    public ResponseData<Integer> checkCommonActivity(SysCheckPo po, SysAccountPO sysAccountPO);

    /**
     * 根据企业品牌获取可以展示在小程序上的活动
     * @param sysCompanyId
     * @param brandId
     * @return
     */
    List<ActivityVO> getActivityForApplet(Long sysCompanyId, Long brandId);

    /**
     * 修改执行中的活动,目前仅仅支持修改适用门店
     * @param bo
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> updateActivityDoing(ActivityBO bo, SysAccountPO sysAccountPO);

    /**
     * 获取签到活动详情
     * @param vo
     * @param pageForm
     * @return
     */
    ResponseData<MktSignInRecordVo> listSignInActivityRecordVo(MktSignInRecordVo vo, PageForm pageForm);

    /**
     * 导出签到活动详情
     * @param vo
     * @param request
     * @return
     */
    ResponseData exportSignInActivityRecordVo(MktSignInRecordVo vo, HttpServletRequest request);

    ResponseData<CtivityAnalysisBO> getActivityRegistrationAnalysisCountpage(ActivityAnalysisCountBO bo, PageForm pageForm);

    ResponseData<CtivityAnalysisBO> getActivityAlipayVoucherAnalysisCountPage(ActivityAnalysisCountBO bo, PageForm pageForm);

    ResponseData<List<OpendCardActivityMumberBO>> getOpenCardActivityNumberListByIdNew(Long id);

    ResponseData<Integer> checkActivityGame(SysCheckPo po, SysAccountPO stageUser);

    /**
     * 根据品牌ID，会员code,订单号查询订单相关活动赠送的最老的可执行游戏信息
     * @param sysBrandId
     * @param memberCode
     * @param orderNo
     * @return
     */
    ResponseData<ActivityGameBO> selectOldGivenGameActivity(Long sysBrandId, String memberCode, String orderNo);

    /**
     * 获取赠送该会员此游戏的剩余有效次数以及总使用次数
     * @param sysBrandId
     * @param memberCode
     * @param activityCode
     * @return
     */
    ResponseData<ActivityGivenGameTimesBO> selectGivenGameNum(Long sysBrandId, String memberCode,String activityCode);

    /**
     * 根据品牌ID，会员，活动ID获取活动赠送的最老游戏记录
     * @param sysBrandId
     * @param memberInfoModel
     * @param activityIds
     * @return
     */
    ActivityGameBO getOldGivenGameActivity(Long sysBrandId, MemberInfoModel memberInfoModel, List<Long> activityIds);

    /**
     * 根据营销ID获取营销对象
     * @param mktActivityId
     * @return
     */
    ResponseData<MktActivityPOWithBLOBs> selectMktActivityById(Long mktActivityId);

    /**
     * 获取活动描述
     * @param requestVO
     * @return
     */
    ResponseData<ActivityInfoResponseVO> getActivityInfo(MktActivitySignInRequestVO requestVO);

    ResponseData<List<ActivityVO>> getGameActivityList(GetGameActivityListReqVO reqVO);

    ResponseData<PageInfo<ActivityGamePrizeListRespVO>> getActivityGamePrizeList(ActivityGamePrizeListReqVO reqVO);
}
