package com.bizvane.mktcenterservice.models.vo.tree3.reqvo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class MktActivityCertificationRecordVo {

    @ApiModelProperty("认证活动记录ID")
    private Long mktActivityCertificationRecordId;

    private Long sysCompanyId;

    private Long sysBrandId;

    @ApiModelProperty("认证活动ID")
    private Long mktActivityCertificationId;

    @ApiModelProperty("会员编号")
    private String membersCode;

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("会员姓名")
    private String memberName;

    @ApiModelProperty("会员手机号")
    private String memberPhone;

    @ApiModelProperty("会员头像")
    private String memberPhoto;

    @ApiModelProperty("认证类型ID")
    private Long certificationTypeId;

    @ApiModelProperty("性别,女:1 男:2 未知:3")
    private String gender;

    @ApiModelProperty("出生日期")
    private Date birthday;

    @ApiModelProperty("身份证号")
    private String idCardNo;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("学历")
    private String eduLevel;

    @ApiModelProperty("首次参加工作日期")
    private String firstWorkDate;

    @ApiModelProperty("工作单位")
    private String workCompany;

    @ApiModelProperty("申请时间")
    private Date applyTime;

    @ApiModelProperty("签到时间")
    private Date signInTime;

    @ApiModelProperty("申请状态 0-未申请 1-已申请")
    private Integer applyState;

    @ApiModelProperty("理论成绩")
    private BigDecimal theoreticalScore;

    @ApiModelProperty("实操成绩")
    private BigDecimal practicalScore;

    @ApiModelProperty("认证状态")
    private Integer certificationState;

    private Long createUserId;

    private String createUserName;

    private Date createDate;

    private Long modifiedUserId;

    private String modifiedUserName;

    private Date modifiedDate;
}