package com.bizvane.mktcenterservice.common;

/**
 *
 * @author yuantq
 * @date 2023/3/3
 */
public enum MktAdvertisementStatusEnum {
    UNDER(0, "已下架"),
    THROW_WAIT(1, "待投放"),
    THROW_IN(2, "投放中"),
    THROW_END(3, "已结束"),
    THROW_CLOSE(4, "已关闭");

    /**
     * 广告状态
     */
    private Integer status;
    /**
     * 广告状态文本
     */
    private String text;

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    MktAdvertisementStatusEnum(Integer status, String text) {
        this.status = status;
        this.text = text;
    }
}
