package com.bizvane.mktcenterservice.rpc.mktp;

import com.bizvane.mktcenterservice.models.vo.mktp.ActivityInvolvedRecordVO;
import com.bizvane.mktcenterservice.models.vo.mktp.MktpActivityAwardRecordVO;
import com.bizvane.mktcenterservice.models.vo.mktp.MktpFissionActivityDataStatisticsRequestVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author yuantq
 * @date 2023/7/7
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/activityExportServiceRpc")
public interface ActivityExportServiceRpc {

    /**
     * 获取参与记录导出数据
     * @param requestVO
     * @return
     */
    @PostMapping("selectExportShareRecordData")
    List<ActivityInvolvedRecordVO> selectExportShareRecordData(@RequestBody MktpFissionActivityDataStatisticsRequestVO requestVO);

    /**
     * 获取获奖记录导出数据
     * @param requestVO
     * @return
     */
    @PostMapping("selectExportAwardRecordData")
    List<MktpActivityAwardRecordVO> selectExportAwardRecordData(@RequestBody MktpFissionActivityDataStatisticsRequestVO requestVO);

}
