package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.models.po.MktActivityAlipayVoucherEntityPO;
import com.bizvane.mktcenterservice.models.po.MktActivityAlipayVoucherPO;
import com.bizvane.mktcenterservice.models.vo.ActivityAlipayVoucherRequestVo;
import com.bizvane.mktcenterservice.models.vo.alipayvoucher.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/activityAlipayVoucherRpc")
public interface ActivityAlipayVoucherRpc {

    @PostMapping(value = "/alipayVoucherCreated")
    ResponseData alipayVoucherCreated(@RequestBody @Valid AlipayVoucherCreatedVo alipayVoucherCreatedVo);

    @PostMapping(value = "/alipayVoucherStopped")
    ResponseData alipayVoucherStopped(@RequestBody @Valid AlipayVoucherStoppedVo alipayVoucherStoppedVo);

    @PostMapping(value = "/alipayVoucherReceivedVo")
    ResponseData alipayVoucherReceivedVo(@RequestBody @Valid AlipayVoucherReceivedVo alipayVoucherReceivedVo);

    @PostMapping(value = "/selectAlipayVoucherByAlipayActivityId")
    ResponseData<MktActivityAlipayVoucherPO> selectAlipayVoucherByAlipayActivityId(@RequestBody @Valid AlipayVoucherQueryVo alipayVoucherQueryVo);

    @PostMapping(value = "/updateAlipayVoucherRecord")
    ResponseData<Integer> updateAlipayVoucherRecord(@RequestBody AlipayVoucherRecordVo alipayVoucherRecordVo);

    @PostMapping(value = "/alipayVoucherPlanEnrollChanged")
    ResponseData alipayVoucherPlanEnrollChanged(@RequestBody @Valid AlipayVoucherPlanEnrollChangedVo alipayVoucherPlanEnrollChangedVo);

    @PostMapping(value = "/alipayVoucherAppended")
    ResponseData alipayVoucherAppended(@RequestBody @Valid AlipayVoucherAppendedVo alipayVoucherAppendedVo);

    @PostMapping(value = "/getAlipayVoucherEntity")
    ResponseData<PageInfo<MktActivityAlipayVoucherEntityPO>> getAlipayVoucherEntity(@RequestBody @Valid ActivityAlipayVoucherRequestVo vo);

    @PostMapping(value = "/getAlipayVoucherEntityByCouponCode")
    ResponseData<MktActivityAlipayVoucherEntityPO> getAlipayVoucherEntityByCouponCode(@RequestParam @NotBlank String couponCode);
}
