package com.bizvane.mktcenter.feign.vo.resp;

import com.bizvane.mktcenter.feign.vo.req.MktActivityVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

@Data
@EqualsAndHashCode(callSuper = false)
public class QueryDetailActivityBirthdayRespVO extends MktActivityVO {

    @ApiModelProperty(value = "执行方式 1按天2按月")
    private Integer dayOrMonth;

    @ApiModelProperty(value = "按日-会员生日前x日发放权益")
    private Integer aheadDays;

    @ApiModelProperty(value = "按月-生日当月注册会员权益发放类型：1注册当日发放2注册次日发放3不发放")
    private Integer birthMonthSendType;

    @ApiModelProperty(value = "活动开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "活动结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime endTime;

}
