package com.bizvane.mktcenter.feign.vo.req;

import com.bizvane.message.feign.vo.mail.MsgMailTempAddRequestVO;
import com.bizvane.message.feign.vo.sms.template.MsgSmsTempAddRequestVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempAddRequestVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

@Data
@EqualsAndHashCode(callSuper = false)
public class AddOrUpdateMktBatchSendMessageReqVO extends BackendLoginBO {

    @ApiModelProperty(value = "营销 - 消息群发系统编号code")
    private String mktBatchSendMessageCode;

    @ApiModelProperty(value = "群发消息名称")
    private String sendMessageName;

    @ApiModelProperty(value = "会员条件类型  1全部会员 2会员分组")
    private Integer mbrConditionType;

    @ApiModelProperty(value = "关联的会员分组系统code")
    private String mbrGroupDefCode;

    @ApiModelProperty(value = "执行时间类型 1立即发送 2定时发送")
    private Integer exeTimeType;

    @ApiModelProperty(value = "定时执行时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime exeTime;

    @ApiModelProperty(value = "消息群发任务类型 1微信小程序订阅消息2短信消息3站内消息")
    private Integer sendMessageType;

    @ApiModelProperty(value = "小程序订阅消息配置")
    private MsgWxMiniProTempAddRequestVO msgWxMiniProTempAddRequestVO;

    @ApiModelProperty(value = "短信消息配置")
    private MsgSmsTempAddRequestVO msgSmsTempAddRequestVO;

    @ApiModelProperty(value = "站内消息配置")
    private MsgMailTempAddRequestVO msgMailTempAddRequestVO;

}
