package com.bizvane.mktcenter.feign.api.mobile;

import com.bizvane.mktcenter.feign.vo.req.mobile.MbrReceiveCouponReqVO;
import com.bizvane.mktcenter.feign.vo.req.mobile.QueryManualListByMerchantNoReqVO;
import com.bizvane.mktcenter.feign.vo.req.mobile.QueryMktManualPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.mobile.QueryManualPageRespVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/mobile/activityManual")
public interface MobileActivityManualFeign {
    @ApiOperation(value = "领取优惠券")
    @PostMapping("/receiveCoupon")
    ResponseData<String> receiveCoupon(@RequestBody MbrReceiveCouponReqVO reqVO);

    @ApiOperation(value = "查询手动领券活动列表")
    @PostMapping("/list")
    ResponseData<List<QueryManualPageRespVO>> list(@RequestBody QueryMktManualPageReqVO reqVO);

    @ApiOperation(value = "扫码领券活动详情")
    @GetMapping("/getDetailByActivityCode")
    ResponseData<QueryManualPageRespVO> getDetailByActivityCode(@RequestParam("mktActivityCode") String mktActivityCode, @RequestParam("mbrMemberCode") String mbrMemberCode);

    @ApiOperation(value = "根据商户号查询手动领券活动列表")
    @PostMapping("/getManualListByMerchantNo")
    ResponseData<List<QueryManualPageRespVO>> getManualListByMerchantNo(@RequestBody QueryManualListByMerchantNoReqVO reqVO);

}
