package com.bizvane.mktcenter.feign.api;

import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/xxlJob")
public interface XxlJobFeign {

    @ApiOperation(value = "积分夺宝 - 抽奖")
    @RequestMapping("/drawLottery")
    ResponseData<String> drawLottery();

    @ApiOperation(value = "营销活动 - 每日job")
    @PostMapping("/everydayJobByActivity")
    ResponseData<String> everydayJobByActivity();

    @ApiOperation(value = "营销任务 - 每日job")
    @PostMapping("/everydayJobByTask")
    ResponseData<String> everydayJobByTask();

    @ApiOperation("签到活动提醒")
    @PostMapping("/everydayJobForSignInActivityNotify")
    ResponseData<String> everydayJobForSignInActivityNotify();

}
