package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.*;
import com.bizvane.mktcenter.feign.vo.SendActivityVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivityPageRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <p>
 * 营销活动主表 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-09
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktActivity")
public interface TMktActivityFeign {

    @PostMapping("/pageList")
    ResponseData<PageInfo<QueryActivityPageRespVO>> pageList(@RequestBody QueryPageActivityPageReqVO reqVO);


    @PostMapping("/disableActivity")
    ResponseData<String> disableActivity(@RequestBody DisableReqVO reqVO);

    @ApiModelProperty(value = "获取活动详情")
    @PostMapping("/getDetail")
    ResponseData<QueryActivityPageRespVO> getDetail(@RequestBody QueryActivityDetailReqVO reqVO);

    @PostMapping("/getList")
    ResponseData<List<QueryActivityPageRespVO>> getList(@RequestBody QueryActivityListReqVO reqVO);

    @ApiModelProperty(value = "发送活动权益")
    @PostMapping("/sendActivityBenefit")
    ResponseData<String> sendActivityBenefit(@RequestBody SendActivityVO sendActivityVO);

    @ApiModelProperty(value = "获取活动优惠券")
    @PostMapping("/getCouponByActivity")
    ResponseData<List<SendActivityVO.SendActivityCouponVO>> getCouponByActivity(@RequestBody GetCouponByActivityReqVO reqVO);

    @ApiOperation(value = "更新活动审核状态")
    @PostMapping("/updateActivityCheckStatus")
    ResponseData<String> updateActivityCheckStatus(@RequestBody UpdateActivityCheckStatusReqVO reqVO);
}

