package com.bizvane.mktcenter.feign.api.mobile;

import com.bizvane.mktcenter.feign.vo.req.PageVO;
import com.bizvane.mktcenter.feign.vo.resp.mobile.QueryMobileNoticeRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/mobile/notice")
public interface MobileNoticeFeign {

    @PostMapping("/pageList")
    ResponseData<PageInfo<QueryMobileNoticeRespVO>> pageList(@RequestBody PageVO pageVO);

    @GetMapping("/getDetail")
    ResponseData<QueryMobileNoticeRespVO> getDetail(@RequestParam("mktNoticeCode") String mktNoticeCode);
}
