package com.bizvane.mktcenter.feign.api.mobile;

import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Set;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/mobile/mktTaskImproveProfile")
public interface MobileMktTaskImproveProfileFeign {

    @GetMapping("/checkTaskImproveProfileByMbr")
    ResponseData<Boolean> checkTaskImproveProfileByMbr(@RequestParam("mbrMemberCode") String mbrMemberCode);

    @GetMapping("/getTaskImproveProfileOptionSetByMbr")
    ResponseData<Set<String>> getTaskImproveProfileOptionSetByMbr(@RequestParam("mbrMemberCode") String mbrMemberCode);

}
