package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktActivityRegisterReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryActivityAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryActivityDetailReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivityRegisterAnalysisPageRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailActivityRegisterRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 活动表-开卡 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-09
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktActivityRegister")
public interface TMktActivityRegisterFeign {

    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateMktActivityRegisterReqVO reqVO);

    @PostMapping("/pageAnalysisList")
    ResponseData<PageInfo<QueryActivityRegisterAnalysisPageRespVO>> pageAnalysisList(@RequestBody QueryActivityAnalysisPageReqVO reqVO);

    @PostMapping("/getDetail")
    ResponseData<QueryDetailActivityRegisterRespVO> getDetail(@RequestBody QueryActivityDetailReqVO reqVO);
}

