package com.bizvane.mktcenter.feign.vo.req;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
public class QueryMktNoticePageReqVO extends PageVO {

    @ApiModelProperty(value = "公告名称")
    private String noticeName;

    @ApiModelProperty(value = "创建时间from")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDateTime createDateStart;

    @ApiModelProperty(value = "创建时间end")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDateTime createDateEnd;

    @ApiModelProperty(value = "创建人名称")
    private String createUserName;

    @ApiModelProperty(value = "账号所属组织code集合（包含子集）,从中台传递过来")
    private List<String> childrenOrgCodeList;
}
