package com.bizvane.mktcenter.feign.vo.req;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
public class QueryMktBatchSendMessagePageReqVO extends PageVO {

    @ApiModelProperty(value = "群发消息名称")
    private String sendMessageName;

    @ApiModelProperty(value = "消息群发任务类型 1微信小程序订阅消息2短信消息3站内消息")
    private Integer sendMessageType;

    @ApiModelProperty(value = "任务状态 1待执行，2执行中，3已结束，4已禁用")
    private Integer status;

    @ApiModelProperty(value = "审核状态：1待审核，2审核中，3已审核，4已驳回， 5审核关闭")
    private Integer checkStatus;

    @ApiModelProperty(value = "消息模板name")
    private String messageTemplateName;

    @ApiModelProperty(value = "定时执行时间-start")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime exeTimeStart;

    @ApiModelProperty(value = "定时执行时间-end")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime exeTimeEnd;
    @ApiModelProperty(value = "账号所属组织code集合（包含子集）,从中台传递过来")
    private List<String> childrenOrgCodeList;
}
