package com.bizvane.mktcenter.feign.vo.req;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

@Data
@EqualsAndHashCode(callSuper = false)
public class AddOrUpdateMktActivityPointLotteryReqVO extends MktActivityVO {

    @ApiModelProperty(value = "至少参与人数")
    private Integer minParticipateNum;

    @ApiModelProperty(value = "每人最多参与次数")
    private Integer maxPerPersonParticipationNum;

    @ApiModelProperty(value = "基础参与次数")
    private Integer baseParticipationNum;

    @ApiModelProperty(value = "消耗积分")
    private Integer consumePoints;

    @ApiModelProperty(value = "消耗总积分")
    private Integer consumePointsSum;

    @ApiModelProperty(value = "退还总积分")
    private Integer returnPointsSum;

    @ApiModelProperty(value = "商品份数")
    private Integer prizeNumber;

    @ApiModelProperty(value = "商品名称")
    private String prizeName;

    @ApiModelProperty(value = "商品图片")
    private String prizeImage;

    @ApiModelProperty(value = "商品价格")
    private Integer prizePrice;

    @ApiModelProperty(value = "商品说明")
    private String prizeInfo;

    @ApiModelProperty(value = "序号")
    private Integer sort;

    @ApiModelProperty(value = "开奖时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDateTime drawPrizeDate;
}
