package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.*;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailMktPopupAdvertisementReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailPopAdvertisementRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryTaskPopupAdvertisementPageRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 营销 - 弹窗广告表 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-23
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktPopupAdvertisement")
public interface TMktPopupAdvertisementFeign {

    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateMktPopupAdvertisementReqVO reqVO);

    @PostMapping("/pageList")
    ResponseData<PageInfo<QueryTaskPopupAdvertisementPageRespVO>> pageList(@RequestBody QueryTaskPopupAdvertisementPageReqVO reqVO);

    @GetMapping("/getDetail")
    ResponseData<QueryDetailMktPopupAdvertisementReqVO> getDetail(@RequestParam("popupAdvertisementCode") String popupAdvertisementCode);

    @PostMapping("/updateShelfStatus")
    ResponseData<String> updateShelfStatus(@RequestBody UpdateShelfStatusReqVO reqVO);

    @PostMapping("/disable")
    ResponseData<String> disable(@RequestBody DisableReqVO reqVO);

    @PostMapping("/updateSort")
    ResponseData<String> updateSort(@RequestBody UpdateSortReqVO reqVO);

    @PostMapping("/saveOrUpdateManage")
    ResponseData<String> saveOrUpdateManage(@RequestBody AddOrUpdatePopAdvertisementManageReqVO reqVO);

    @GetMapping("/getManage")
    ResponseData<QueryDetailPopAdvertisementRespVO> getManage();

    @ApiOperation(value = "弹窗广告-审核回调")
    @PostMapping("/updateCheckStatus")
    ResponseData<String> updateCheckStatus(@RequestBody UpdatePopupNoticeCheckStatusReqVO reqVO);
}

