package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktActivityEvaluateReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryActivityAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryActivityDetailReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivityEvaluateAnalysisPageRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailActivityEvaluateRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 营销活动 - 评价有礼 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-22
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktActivityEvaluate")
public interface TMktActivityEvaluateFeign {

    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateMktActivityEvaluateReqVO reqVO);

    @PostMapping("/analysisPageList")
    ResponseData<PageInfo<QueryActivityEvaluateAnalysisPageRespVO>> analysisPageList(@RequestBody QueryActivityAnalysisPageReqVO reqVO);

    @PostMapping("/getDetail")
    ResponseData<QueryDetailActivityEvaluateRespVO> getDetail(@RequestBody QueryActivityDetailReqVO reqVO);

}

