package com.bizvane.mktcenter.feign.api;

import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktTaskInviteRegisterReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryTaskAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryTaskDetailReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailTaskInviteRegisterRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryTaskInviteRegisterAnalysisPageRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 营销任务-邀请入会 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-17
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktTaskInviteRegister")
public interface TMktTaskInviteRegisterFeign {

    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateMktTaskInviteRegisterReqVO reqVO);

    @PostMapping("/analysisPageList")
    ResponseData<PageInfo<QueryTaskInviteRegisterAnalysisPageRespVO>> analysisPageList(@RequestBody QueryTaskAnalysisPageReqVO reqVO);

    @PostMapping("/getDetail")
    ResponseData<QueryDetailTaskInviteRegisterRespVO> getDetail(@RequestBody QueryTaskDetailReqVO reqVO);

}

