package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktBatchSendMessageReqVO;
import com.bizvane.mktcenter.feign.vo.req.DisableReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryMktBatchSendMessagePageReqVO;
import com.bizvane.mktcenter.feign.vo.req.UpdateBatchSendCheckStatusReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailBatchSendMessageRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryMktBatchSendMessagePageRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 营销 - 消息群发 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-24
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktBatchSendMessage")
public interface TMktBatchSendMessageFeign {
    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateMktBatchSendMessageReqVO reqVO);

    @PostMapping("/pageList")
    ResponseData<PageInfo<QueryMktBatchSendMessagePageRespVO>> pageList(@RequestBody QueryMktBatchSendMessagePageReqVO reqVO);

    @GetMapping("/getDetail")
    ResponseData<QueryDetailBatchSendMessageRespVO> getDetail(@RequestParam("mktBatchSendMessageCode") String mktBatchSendMessageCode);

    @PostMapping("/disable")
    ResponseData<String> disable(@RequestBody DisableReqVO reqVO);

    @ApiOperation(value = "修改审核状态")
    @PostMapping("/updateCheckStatus")
    ResponseData<String> updateCheckStatus(@RequestBody UpdateBatchSendCheckStatusReqVO reqVO);

    @ApiOperation(value = "修改状态")
    @PostMapping("/updateStatus")
    ResponseData<String> updateStatus(@RequestParam("mktBatchSendMessageCode") String mktBatchSendMessageCode, @RequestParam("status") Integer status);
}

