package com.bizvane.mktcenter.feign.vo.resp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
public class QueryMktBatchSendMessagePageRespVO {

    @ApiModelProperty(value = "营销 - 消息群发系统编号code")
    private String mktBatchSendMessageCode;

    @ApiModelProperty(value = "群发消息名称")
    private String sendMessageName;

    @ApiModelProperty(value = "消息群发任务类型 1微信小程序订阅消息2短信消息3站内消息")
    private Integer sendMessageType;

    @ApiModelProperty(value = "消息模板code")
    private String messageTemplateCode;

    @ApiModelProperty(value = "消息模板名称")
    private String messageTemplateName;

    @ApiModelProperty(value = "定时执行时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date exeTime;

    @ApiModelProperty(value = "发送成功数")
    private Long successNum;

    @ApiModelProperty(value = "发送失败数")
    private Long failNum;

    @ApiModelProperty(value = "任务状态 1待执行，2执行中，3已结束，4已禁用")
    private Integer status;

    @ApiModelProperty(value = "审核状态：1待审核，2审核中，3已审核，4已驳回， 5审核关闭")
    private Integer checkStatus;

    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String createDate;

    @ApiModelProperty(value = "创建人名称")
    private String createUserName;

    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String modifiedDate;

    @ApiModelProperty(value = "更新人名称")
    private String modifiedUserName;
}
