package com.bizvane.mktcenter.feign.vo;

import com.bizvane.utils.enumutils.CouponSendTypeEnum;
import com.bizvane.utils.enumutils.IntegralBusinessWayEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class SendActivityVO {

    @ApiModelProperty(value = "活动系统编号code")
    private String mktActivityCode;

    @ApiModelProperty(value = "活动名称")
    private String activityName;

    @ApiModelProperty(value = "活动编号")
    private String activityNo;

    @ApiModelProperty(value = "活动类型：1开卡活动，2升级活动，3手动领券，4消费活动，5签到活动，6生日活动，7积分夺宝")
    private Integer activityType;

    @ApiModelProperty(value = "赠送积分")
    private Integer integral;

    @ApiModelProperty(value = "赠送优惠券code列表")
    private List<SendActivityCouponVO> activityCouponList;

    @ApiModelProperty(value = "关联业务编号\\n升级活动：等级系统编号\\n消费活动：订单系统编号\\n签到活动：签到记录系统编号")
    private String businessCode;

    @ApiModelProperty(value = "签到活动：签到奖励规则系统编号")
    private String mktActivitySignInPrizeCode;

    private CouponSendTypeEnum couponSendTypeEnum;

    private IntegralBusinessWayEnum integralBusinessWayEnum;

    @ApiModelProperty(value = "会员code列表")
    private List<String> memberCodeList;

    @Data
    public static class SendActivityCouponVO {

        @ApiModelProperty(value = "营销活动优惠券权益系统编号code")
        private String mktActivityCouponCode;

        @ApiModelProperty(value = "关联活动系统code")
        private String mktActivityCode;

        @ApiModelProperty(value = "签到奖励规则系统编号code（仅签到活动用）")
        private String mktActivitySignInPrizeCode;

        @ApiModelProperty(value = "优惠券系统编号code")
        private String couponCode;
    }
}
