package com.bizvane.mktcenter.feign.vo.req;

import com.bizvane.mktcenter.feign.vo.CouponDefVO;
import com.bizvane.mktcenter.feign.vo.MbrLevelDefVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
public class MktActivityVO extends BackendLoginBO {

    @ApiModelProperty(value = "活动系统编号code")
    private String mktActivityCode;

    @ApiModelProperty(value = "活动名称")
    private String activityName;

    @ApiModelProperty(value = "会员条件类型  1全部会员 2会员分组 3会员等级")
    private Integer mbrConditionType;

    @ApiModelProperty(value = "关联的会员分组系统code")
    private String mbrGroupDefCode;

    @ApiModelProperty(value = "关联的会员分组系统名称")
    private String mbrGroupDefName;

    @ApiModelProperty(value = "会员等级列表")
    private List<MbrLevelDefVO> levelList;

    @ApiModelProperty(value = "是否长期：1是，0否")
    private Integer longTerm;

    @ApiModelProperty(value = "活动开始时间")
    private String startTime;

    @ApiModelProperty(value = "活动结束时间")
    private String endTime;

    @ApiModelProperty(value = "0=文字   1=图片")
    private Integer activityDescType;

    @ApiModelProperty(value = "活动描述、简介")
    private String activityDesc;

    @ApiModelProperty(value = "活动详情图片")
    private String activityDescImg;

    @ApiModelProperty(value = "活动图片，多张逗号分隔")
    private String activityImg;

    @ApiModelProperty(value = "赠送积分")
    private Integer integral;

    @ApiModelProperty(value = "活动状态：1待执行，2执行中，3已结束，4已禁用")
    private Integer activityStatus;

    @ApiModelProperty(value = "赠送优惠券code列表")
    private List<CouponDefVO> couponCodeList;
}
