package com.bizvane.mktcenter.feign.api.mobile;

import com.bizvane.mktcenter.feign.vo.req.ActivityPointLotteryReceivePrizeReqVO;
import com.bizvane.mktcenter.feign.vo.req.mobile.MobilePointsLotteryReqVO;
import com.bizvane.mktcenter.feign.vo.req.mobile.QueryPointLotteryPageReqVO;
import com.bizvane.mktcenter.feign.vo.req.mobile.QueryPointLotteryRecordPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.mobile.QueryPointLotteryPageRespVO;
import com.bizvane.mktcenter.feign.vo.resp.mobile.QueryPointLotteryRecordPageRespVO;
import com.bizvane.mktcenter.feign.vo.resp.mobile.QueryPointsLotteryPrizeDetailRespVO;
import com.bizvane.mktcenter.feign.vo.resp.mobile.QueryPointsLotteryRuleRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/mobile/pointsLottery")
public interface MobilePointsLotteryFeign {
    @ApiOperation(value = "参与积分夺宝活动")
    @PostMapping("/joinPointLottery")
    ResponseData<String> joinPointLottery(@RequestBody MobilePointsLotteryReqVO reqVO);

    @ApiOperation(value = "领取积分夺宝奖品")
    @PostMapping("/receivePrize")
    ResponseData<String> receivePrize(@RequestBody ActivityPointLotteryReceivePrizeReqVO reqVO);

    @ApiOperation(value = "获取积分夺宝规则")
    @GetMapping("/getPointsLotteryRule")
    ResponseData<QueryPointsLotteryRuleRespVO> getPointsLotteryRule(@RequestParam("mbrMemberCode") String mbrMemberCode);

    @ApiOperation(value = "获取积分夺宝活动分页")
    @PostMapping("/getPointsLottery")
    ResponseData<List<QueryPointLotteryPageRespVO>> getPointsLotteryPage(@RequestBody QueryPointLotteryPageReqVO reqVO);

    @ApiOperation(value = "获取积分夺宝参与记录分页")
    @PostMapping("/getPointsLotteryRecordPage")
    ResponseData<PageInfo<QueryPointLotteryRecordPageRespVO>> getPointsLotteryRecordPage(@RequestBody QueryPointLotteryRecordPageReqVO reqVO);

    @ApiOperation(value = "获取积分夺宝奖品详情")
    @GetMapping("/getPrizeDetail")
    ResponseData<QueryPointsLotteryPrizeDetailRespVO> getPrizeDetail(@RequestParam("mktActivityCode") String mktActivityCode);
}
