
package com.bizvane.mktcenter.feign.api.mobile;

import com.bizvane.mktcenter.feign.vo.req.MobileMktFortuneWheelReqVO;
import com.bizvane.mktcenter.feign.vo.resp.mobile.QueryDetailFortuneWheelPrizeRespVO;
import com.bizvane.mktcenter.feign.vo.resp.mobile.QueryDetailFortuneWheelRespVO;
import com.bizvane.mktcenter.feign.vo.resp.mobile.QueryFortuneWheelByMbrRespVO;
import com.bizvane.mktcenter.feign.vo.resp.mobile.QueryFortuneWheelWinRecordPageRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/mobile/activityFortuneWheel")
public interface MobileActivityFortuneWheelFeign {

    @ApiOperation(value = "获取大转盘活动详情")
    @GetMapping("/getDetail")
    ResponseData<QueryDetailFortuneWheelRespVO> getDetail(String mktActivityCode);

    @ApiOperation(value = "获取会员的积分和活动信息")
    @PostMapping("/getFortuneWheelByMbr")
    ResponseData<QueryFortuneWheelByMbrRespVO> getFortuneWheelByMbr(@RequestBody MobileMktFortuneWheelReqVO reqVO);

    @ApiOperation(value = "参与大转盘活动")
    @PostMapping("/join")
    ResponseData<QueryDetailFortuneWheelPrizeRespVO> join(@RequestBody MobileMktFortuneWheelReqVO reqVO);

    @ApiOperation(value = "获取中奖记录")
    @PostMapping("/winRecordPage")
    ResponseData<PageInfo<QueryFortuneWheelWinRecordPageRespVO>> winRecordPage(@RequestBody MobileMktFortuneWheelReqVO reqVO);
}
