package com.bizvane.mktcenter.feign.api;

import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateStaffBenefitTypeReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryStaffBenefitTypePageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryStaffBenefitTypeRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 员工福利类型 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-11-11
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktStaffBenefitType")
public interface TMktStaffBenefitTypeFeign {

    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdateType(@RequestBody AddOrUpdateStaffBenefitTypeReqVO reqVO);

    @GetMapping("/getDetail")
    ResponseData<QueryStaffBenefitTypeRespVO> getDetail(@RequestParam("mktStaffBenefitTypeCode") String mktStaffBenefitTypeCode);

    @PostMapping("/pageList")
    ResponseData<PageInfo<QueryStaffBenefitTypeRespVO>> pageList(@RequestBody QueryStaffBenefitTypePageReqVO reqVO);

}
