package com.bizvane.mktcenter.feign.api;

import com.bizvane.mktcenter.feign.vo.req.*;
import com.bizvane.mktcenter.feign.vo.resp.QueryStaffBenefitDetailRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 员工福利 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-11-11
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktStaffBenefit")
public interface TMktStaffBenefitFeign {

    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateStaffBenefitReqVO reqVO);

    @GetMapping("/getDetail")
    ResponseData<QueryStaffBenefitDetailRespVO> getDetail(@RequestParam("mktStaffBenefitCode") String mktStaffBenefitCode);

    @PostMapping("/pageList")
    ResponseData<PageInfo<QueryStaffBenefitDetailRespVO>> pageList(@RequestBody QueryStaffBenefitPageReqVO reqVO);

    @PostMapping("/updateUpState")
    ResponseData<String> updateUpState(@RequestBody UpdateShelfStatusReqVO reqVO);

    @PostMapping("/updateSort")
    ResponseData<String> updateSort(@RequestBody UpdateSortReqVO reqVO);

    @PostMapping("/disable")
    ResponseData<String> disable(@RequestBody DisableReqVO reqVO);
}
