package com.bizvane.mktcenter.feign.vo.req;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
public class MktTaskVO extends BackendLoginBO {

    @ApiModelProperty(value = "任务系统编号code")
    private String mktTaskCode;

    @ApiModelProperty(value = "任务名称")
    private String taskName;

    @ApiModelProperty(value = "会员条件类型  1全部会员 2会员分组")
    private Integer mbrConditionType;

    @ApiModelProperty(value = "关联的会员分组系统code")
    private String mbrGroupDefCode;

    @ApiModelProperty(value = "关联的会员分组系统名称")
    private String mbrGroupDefName;

    @ApiModelProperty(value = "是否长期：1是，0否")
    private Integer longTerm;

    @ApiModelProperty(value = "任务开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    @ApiModelProperty(value = "任务结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    @ApiModelProperty(value = "0=文字   1=图片")
    private Integer taskDescType;

    @ApiModelProperty(value = "任务描述、简介")
    private String taskDesc;

    @ApiModelProperty(value = "任务详情图片")
    private String taskDescImg;

    @ApiModelProperty(value = "任务图片，多张逗号分隔")
    private String taskImg;

    @ApiModelProperty(value = "赠送积分")
    private Integer integral;

    @ApiModelProperty(value = "赠送优惠券code列表")
    private List<String> couponCodeList;
}
