package com.bizvane.mktcenter.feign.vo.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
public class AddOrUpdateMktOrderRegisterReqVO extends MktActivityVO {

    @ApiModelProperty(value = "消费渠道code，英文逗号分隔")
    private List<String> consumeChannelCode;

    @ApiModelProperty(value = "最小金额限制 单位分")
    private Integer minOrderAmount;

    @ApiModelProperty(value = "最大金额限制 单位分")
    private Integer maxOrderAmount;

    @ApiModelProperty(value = "最小订单折扣 %")
    private Integer minOrderDiscount;

    @ApiModelProperty(value = "最大订单折扣 %")
    private Integer maxOrderDiscount;

    @ApiModelProperty(value = "是否是首购订单：0否1是")
    private Integer firstOrder;

    @ApiModelProperty(value = "订单限制范围 0不限制1按业态2按商户")
    private Integer orderLimitType;

    @ApiModelProperty(value = "机场限制，英文逗号分隔")
    private List<String> airportLimit;

    @ApiModelProperty(value = "业态code 英文逗号分隔")
    private List<String> businessCode;

    @ApiModelProperty(value = "商户code 缓存key")
    private String merchantCodeSelectedKey;
}
