package com.bizvane.mktcenter.feign.vo.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
public class AddOrUpdateMktBatchSendMessageReqVO extends BackendLoginBO {

    @ApiModelProperty(value = "营销 - 消息群发系统编号code")
    private String mktBatchSendMessageCode;

    @ApiModelProperty(value = "群发消息名称")
    private String sendMessageName;

    @ApiModelProperty(value = "会员条件类型  1全部会员 2会员分组")
    private Integer mbrConditionType;

    @ApiModelProperty(value = "关联的会员分组系统code")
    private String mbrGroupDefCode;

    @ApiModelProperty(value = "执行时间类型 1立即发送 2定时发送")
    private Integer exeTimeType;

    @ApiModelProperty(value = "定时执行时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date exeTime;

    @ApiModelProperty(value = "消息群发任务类型 1微信小程序订阅消息2短信消息3站内消息")
    private Integer sendMessageType;

    @ApiModelProperty(value = "消息模板code")
    private String messageTemplateCode;

    @ApiModelProperty(value = "消息链接")
    private String messageLink;

    @ApiModelProperty(value = "消息链接名称")
    private String messageLinkName;

}
