package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktTaskBoardReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryTaskAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailTaskBoardRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryTaskBoardAnalysisPageRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 营销任务 - 会员乘机 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-21
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktTaskMbrBoard")
public interface TMktTaskMbrBoardFeign {

    @ApiOperation(value = "保存或更新")
    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateMktTaskBoardReqVO reqVO);

    @ApiOperation(value = "效果分析分页查询")
    @PostMapping("/analysisPageList")
    ResponseData<PageInfo<QueryTaskBoardAnalysisPageRespVO>> analysisPageList(@RequestBody QueryTaskAnalysisPageReqVO reqVO);

    @ApiOperation(value = "获取详情")
    @GetMapping("/getDetail")
    ResponseData<QueryDetailTaskBoardRespVO> getDetail(@RequestParam("mktActivityCode") String mktActivityCode);

}

