package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktPopupAdvertisementReqVO;
import com.bizvane.mktcenter.feign.vo.req.AddOrUpdatePopAdvertisementManageReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryTaskPopupAdvertisementPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailMktPopupAdvertisementReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailPopAdvertisementRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryTaskPopupAdvertisementPageRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 营销 - 弹窗广告表 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-23
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktPopupAdvertisement")
public interface TMktPopupAdvertisementFeign {

    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateMktPopupAdvertisementReqVO reqVO);

    @PostMapping("/pageList")
    ResponseData<PageInfo<QueryTaskPopupAdvertisementPageRespVO>> pageList(@RequestBody QueryTaskPopupAdvertisementPageReqVO reqVO);

    @GetMapping("/getDetail")
    ResponseData<QueryDetailMktPopupAdvertisementReqVO> getDetail(@RequestParam("popupAdvertisementCode") String popupAdvertisementCode);

    @PostMapping("/updateShelfStatus")
    ResponseData<String> updateShelfStatus(@RequestParam("popupAdvertisementCode") String popupAdvertisementCode, @RequestParam("shelfStatus") Integer shelfStatus);

    @PostMapping("/disable")
    ResponseData<String> disable(@RequestParam("popupAdvertisementCode") String popupAdvertisementCode);

    @PostMapping("/updateSort")
    ResponseData<String> updateSort(@RequestParam("popupAdvertisementCode") String popupAdvertisementCode, @RequestParam("sort") Integer sort);

    @PostMapping("/saveOrUpdateManage")
    ResponseData<String> saveOrUpdateManage(AddOrUpdatePopAdvertisementManageReqVO reqVO);

    @GetMapping("/getManage")
    ResponseData<QueryDetailPopAdvertisementRespVO> getManage();
}

