package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktNoticeReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryMktNoticePageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailMktNoticeRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryMktNoticePageRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 营销 - 通知公告 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-24
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktNotice")
public interface TMktNoticeFeign {

    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateMktNoticeReqVO reqVO);

    @PostMapping("/pageList")
    ResponseData<PageInfo<QueryMktNoticePageRespVO>> pageList(@RequestBody QueryMktNoticePageReqVO reqVO);

    @GetMapping("/getDetail")
    ResponseData<QueryDetailMktNoticeRespVO> getDetail(String mktNoticeCode);

    @PostMapping("/delete")
    ResponseData<String> delete(@RequestParam("mktNoticeCode") String mktNoticeCode);

}

