package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktActivityUpgradeReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryActivityAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivityUpgradeAnalysisPageRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailActivityUpgradeRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 活动表-会员升级 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-10
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktActivityUpgrade")
public interface TMktActivityUpgradeFeign {

    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateMktActivityUpgradeReqVO reqVO);

    @PostMapping("/analysisPageList")
    ResponseData<PageInfo<QueryActivityUpgradeAnalysisPageRespVO>> analysisPageList(@RequestBody QueryActivityAnalysisPageReqVO reqVO);

    @GetMapping("/getDetail")
    ResponseData<QueryDetailActivityUpgradeRespVO> getDetail(@RequestParam("mktActivityCode") String mktActivityCode);

}

