package com.bizvane.mktcenter.feign.api;


import com.bizvane.mktcenter.feign.vo.req.QueryPageActivityPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryActivityPageRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 营销活动主表 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-10-09
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/tMktActivity")
public interface TMktActivityFeign {

    @PostMapping("/pageList")
    ResponseData<PageInfo<QueryActivityPageRespVO>> pageList(@RequestBody QueryPageActivityPageReqVO reqVO);


    @PostMapping("/disableActivity")
    ResponseData<String> disableActivity(@RequestParam("mktActivityCode") String mktActivityCode);
}

