/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.client.web;

import com.bizvane.base.common.bean.ErrorInfo;
import com.bizvane.base.common.bean.ListResultBean;
import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.remote.dto.TemplateAddDto;
import com.bizvane.base.remote.dto.TemplateDto;
import com.bizvane.message.component.BaseComponent;
import com.bizvane.message.component.bean.BizvaneExceptionEnum;
import com.bizvane.message.component.bean.MessageException;
import com.bizvane.message.component.bean.MessageStrategyEnum;
import com.bizvane.message.component.bean.TemplateBean;
import com.bizvane.message.component.bean.TemplateTypeEnum;
import com.bizvane.message.service.TemplateService;
import com.bizvane.message.utils.MessageConvertutil;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/message"})
@Validated
public class RemoteTemplateController {
    private static final Logger log = LoggerFactory.getLogger(RemoteTemplateController.class);
    @Autowired
    private Map<String, BaseComponent> baseComponentMap;
    @Autowired
    private TemplateService templateService;

    @RequestMapping(method={RequestMethod.POST}, value={"/createTemplate"}, produces={"application/json"})
    public ResultBean<TemplateDto> createTemplate(@RequestParam(value="merchantId") @NotBlank(message="merchantId not null") @NotBlank(message="merchantId not null") String merchantId, @RequestParam(value="channelType") @NotBlank(message="channelType not null") @NotBlank(message="channelType not null") String channelType, @RequestParam(value="templateName") @NotBlank(message="templateName not null") @NotBlank(message="templateName not null") String templateName, @RequestParam(value="templateType") @NotBlank(message="templateType not null") @NotBlank(message="templateType not null") String templateType, @RequestParam(value="templateContent") @NotBlank(message="templateContent not null") @NotBlank(message="templateContent not null") String templateContent, @RequestParam(value="remark") @NotBlank(message="remark not null") @NotBlank(message="remark not null") String remark, @RequestParam(value="postFix", required=false) String postFix, @RequestParam(value="sysCode") @NotBlank(message="sysCode not null") @NotBlank(message="sysCode not null") String sysCode, @RequestParam(value="signatures", required=false) String signatures, @RequestParam(value="originalContent", required=false) String originalContent, @RequestParam(value="attach", required=false) String attach) {
        String strategy;
        ResultBean resultBean = new ResultBean();
        resultBean.setSuccess(Boolean.FALSE);
        if (TemplateTypeEnum.YX.getValue().equals(templateType)) {
            if (StringUtils.isBlank((CharSequence)postFix)) {
                resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.YX_TEMPLATE_POST_FIX_ERROR.getErrCode(), BizvaneExceptionEnum.YX_TEMPLATE_POST_FIX_ERROR.getErrCodeDes()));
                return resultBean;
            }
            Boolean checkStatus = this.checkParam(templateContent);
            if (templateContent.contains("${") && checkStatus.booleanValue()) {
                resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.YX_TEMPLATE_CAN_NOT_CONTAINS_VARI.getErrCode(), BizvaneExceptionEnum.YX_TEMPLATE_CAN_NOT_CONTAINS_VARI.getErrCodeDes()));
                return resultBean;
            }
        }
        if (StringUtils.isBlank((CharSequence)(strategy = MessageStrategyEnum.getStrategyByType((String)channelType)))) {
            resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.PARAM_CHANNEL_TYPE_ERROR.getErrCode(), BizvaneExceptionEnum.PARAM_CHANNEL_TYPE_ERROR.getErrCodeDes()));
            return resultBean;
        }
        if (StringUtils.isBlank((CharSequence)TemplateTypeEnum.getValue((String)templateType))) {
            resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.PARAM_TEMPLATE_TYPE_ERROR.getErrCode(), BizvaneExceptionEnum.PARAM_TEMPLATE_TYPE_ERROR.getErrCodeDes()));
            return resultBean;
        }
        BaseComponent component = (BaseComponent)this.baseComponentMap.get(strategy);
        try {
            TemplateBean template;
            if (templateContent.contains("{$")) {
                resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.TEMPLATE_CONTENT_PARAM_ILLEGAL.getErrCode(), BizvaneExceptionEnum.TEMPLATE_CONTENT_PARAM_ILLEGAL.getErrCodeDes()));
                return resultBean;
            }
            if (channelType.equals(MessageStrategyEnum.CHUANGLAN_STRATEGY.getType()) && StringUtils.isNotBlank((CharSequence)templateContent) && templateContent.contains("${")) {
                templateContent = MessageConvertutil.converTemplateContent((String)templateContent);
            }
            if ((template = component.createTemplate(merchantId, channelType, templateName, templateType, templateContent, remark, signatures, sysCode, originalContent, attach, postFix)) != null) {
                TemplateDto templateDto = new TemplateDto();
                BeanUtils.copyProperties((Object)template, (Object)templateDto);
                templateDto.setSysCode(sysCode);
                templateDto.setAuditReason(template.getAuditReason());
                resultBean.setSuccess(Boolean.TRUE);
                resultBean.setResult((Object)templateDto);
            }
        }
        catch (MessageException e) {
            log.error("\u521b\u5efa\u6a21\u677f\u5f02\u5e38:{},{}", (Object)e.getErrCodeDes(), (Object)e);
            resultBean.setErrorInfo(new ErrorInfo(e.getErrCode(), e.getErrCodeDes()));
        }
        return resultBean;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/createTemplateNew"})
    public ResultBean<TemplateDto> createTemplateNew(@RequestBody TemplateAddDto dto) {
        String strategy;
        String merchantId = dto.getMerchantId();
        String channelType = dto.getChannelType();
        String templateName = dto.getTemplateName();
        String templateType = dto.getTemplateType();
        String templateContent = dto.getTemplateContent();
        String remark = dto.getRemark();
        String postFix = dto.getPostFix();
        String sysCode = dto.getSysCode();
        String signatures = dto.getSignatures();
        String originalContent = dto.getOriginalContent();
        String attach = dto.getAttach();
        ResultBean resultBean = new ResultBean();
        resultBean.setSuccess(Boolean.FALSE);
        if (TemplateTypeEnum.YX.getValue().equals(templateType)) {
            if (StringUtils.isBlank((CharSequence)postFix)) {
                resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.YX_TEMPLATE_POST_FIX_ERROR.getErrCode(), BizvaneExceptionEnum.YX_TEMPLATE_POST_FIX_ERROR.getErrCodeDes()));
                return resultBean;
            }
            Boolean checkStatus = this.checkParam(templateContent);
            if (templateContent.contains("${") && checkStatus.booleanValue()) {
                resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.YX_TEMPLATE_CAN_NOT_CONTAINS_VARI.getErrCode(), BizvaneExceptionEnum.YX_TEMPLATE_CAN_NOT_CONTAINS_VARI.getErrCodeDes()));
                return resultBean;
            }
        }
        if (StringUtils.isBlank((CharSequence)(strategy = MessageStrategyEnum.getStrategyByType((String)channelType)))) {
            resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.PARAM_CHANNEL_TYPE_ERROR.getErrCode(), BizvaneExceptionEnum.PARAM_CHANNEL_TYPE_ERROR.getErrCodeDes()));
            return resultBean;
        }
        if (StringUtils.isBlank((CharSequence)TemplateTypeEnum.getValue((String)templateType))) {
            resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.PARAM_TEMPLATE_TYPE_ERROR.getErrCode(), BizvaneExceptionEnum.PARAM_TEMPLATE_TYPE_ERROR.getErrCodeDes()));
            return resultBean;
        }
        BaseComponent component = (BaseComponent)this.baseComponentMap.get(strategy);
        try {
            TemplateBean template;
            if (templateContent.contains("{$")) {
                resultBean.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.TEMPLATE_CONTENT_PARAM_ILLEGAL.getErrCode(), BizvaneExceptionEnum.TEMPLATE_CONTENT_PARAM_ILLEGAL.getErrCodeDes()));
                return resultBean;
            }
            if (channelType.equals(MessageStrategyEnum.CHUANGLAN_STRATEGY.getType()) && StringUtils.isNotBlank((CharSequence)templateContent) && templateContent.contains("${")) {
                templateContent = MessageConvertutil.converTemplateContent((String)templateContent);
            }
            if ((template = component.createTemplate(merchantId, channelType, templateName, templateType, templateContent, remark, signatures, sysCode, originalContent, attach, postFix)) != null) {
                TemplateDto templateDto = new TemplateDto();
                BeanUtils.copyProperties((Object)template, (Object)templateDto);
                templateDto.setSysCode(sysCode);
                templateDto.setAuditReason(template.getAuditReason());
                resultBean.setSuccess(Boolean.TRUE);
                resultBean.setResult((Object)templateDto);
            }
        }
        catch (MessageException e) {
            log.error("\u521b\u5efa\u6a21\u677f\u5f02\u5e38:{},{}", (Object)e.getErrCodeDes(), (Object)e);
            resultBean.setErrorInfo(new ErrorInfo(e.getErrCode(), e.getErrCodeDes()));
        }
        return resultBean;
    }

    private Boolean checkParam(String templateContent) {
        Boolean status = true;
        try {
            String newContent = new String(templateContent);
            String replaceAll = newContent.replaceAll("\\$\\{memberCardNo\\}", "").replaceAll("\\$\\{memberName\\}", "").replaceAll("\\$\\{integralCount\\}", "").replaceAll("\\$\\{phone\\}", "").replaceAll("\\$\\{memberLevel\\}", "");
            if (!replaceAll.contains("${")) {
                status = false;
            }
            log.info("\u8425\u9500\u77ed\u4fe1\u6a21\u677f\u53c2\u6570\u6821\u9a8c\uff1a{}  {}", (Object)templateContent, (Object)replaceAll);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/queryTemplate"}, produces={"application/json"})
    public ResultBean<TemplateDto> queryTemplate(@RequestParam(value="merchantId") @NotBlank(message="merchantId not null") @NotBlank(message="merchantId not null") String merchantId, @RequestParam(value="channelType") @NotBlank(message="channelType not null") @NotBlank(message="channelType not null") String channelType, @RequestParam(value="templateCode") @NotBlank(message="templateCode not null") @NotBlank(message="templateCode not null") String templateCode) {
        ResultBean resultBean = new ResultBean();
        resultBean.setSuccess(Boolean.TRUE);
        String strategy = MessageStrategyEnum.getStrategyByType((String)channelType);
        BaseComponent component = (BaseComponent)this.baseComponentMap.get(strategy);
        try {
            TemplateBean templateBean = component.queryTemplate(merchantId, channelType, templateCode);
            TemplateDto templateDto = new TemplateDto();
            if (templateBean != null) {
                BeanUtils.copyProperties((Object)templateBean, (Object)templateDto);
            }
            resultBean.setResult((Object)templateDto);
        }
        catch (MessageException e) {
            log.error("\u67e5\u8be2\u6a21\u677f\u5f02\u5e38:{},{}", (Object)e.getErrCodeDes(), (Object)e);
            resultBean.setSuccess(Boolean.FALSE);
            resultBean.setErrorInfo(new ErrorInfo(e.getErrCode(), e.getErrCodeDes()));
        }
        return resultBean;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/queryTemplatePage"}, produces={"application/json"})
    public ListResultBean<TemplateDto> queryTemplatePage(@RequestParam(value="merchantId") @NotBlank(message="merchantId not null") @NotBlank(message="merchantId not null") String merchantId, @RequestParam(value="channelType") @NotBlank(message="channelType not null") @NotBlank(message="channelType not null") String channelType, @RequestParam(value="templateCode", required=false) String templateCode, @RequestParam(value="templateType", required=false) String templateType, @RequestParam(value="status", required=false) String status, @RequestParam(value="templateName", required=false) String templateName, @RequestParam(value="sysCode", required=false) String sysCode, @RequestParam(value="remark", required=false) String remark, @RequestParam(value="pageNum", defaultValue="0", required=false) Long pageNum, @RequestParam(value="pageSize", defaultValue="10", required=false) Long pageSize) {
        ListResultBean result = new ListResultBean();
        result.setSuccess(Boolean.valueOf(false));
        try {
            String channelId = merchantId + "_" + channelType;
            result = this.templateService.getPage(merchantId, channelId, templateCode, templateType, templateName, remark, status, sysCode, pageNum, pageSize);
            result.setSuccess(Boolean.valueOf(true));
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6a21\u677f\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            result.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCode(), BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCodeDes()));
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/queryTemplatePageMultiMerchant"}, produces={"application/json"})
    public ListResultBean<TemplateDto> queryTemplatePageMultiMerchant(@RequestParam(value="merchantIds") String merchantIds, @RequestParam(value="templateCode", required=false) String templateCode, @RequestParam(value="templateType", required=false) String templateType, @RequestParam(value="status", required=false) String status, @RequestParam(value="templateName", required=false) String templateName, @RequestParam(value="sysCode", required=false) String sysCode, @RequestParam(value="remark", required=false) String remark, @RequestParam(value="pageNum", defaultValue="0", required=false) Long pageNum, @RequestParam(value="pageSize", defaultValue="10", required=false) Long pageSize) {
        ListResultBean result = new ListResultBean();
        result.setSuccess(Boolean.valueOf(false));
        try {
            List channelIds = null;
            if (!StringUtils.isEmpty((CharSequence)merchantIds)) {
                channelIds = Splitter.on((String)",").splitToList((CharSequence)merchantIds);
            }
            result = this.templateService.getPageMultiMerchant(channelIds, templateCode, templateType, templateName, remark, status, sysCode, pageNum, pageSize);
            result.setSuccess(Boolean.valueOf(true));
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6a21\u677f\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            result.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCode(), BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCodeDes()));
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/getMerchantIdByTemplateCode"}, produces={"application/json"})
    public ResultBean<String> getMerchantIdByTemplateCode(@RequestParam(value="templateCode") String templateCode) {
        ResultBean result = new ResultBean();
        result.setSuccess(Boolean.valueOf(false));
        try {
            String merchantId = this.templateService.getMerchantIdByTemplateCode(templateCode);
            result.setResult((Object)merchantId);
            result.setSuccess(Boolean.valueOf(true));
        }
        catch (Exception e) {
            log.error("\u6839\u636etemplate\u67e5\u8be2merchantId\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            result.setErrorInfo(new ErrorInfo(BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCode(), BizvaneExceptionEnum.MESSAGE_GATEWAY_INTERNAL_ERROR.getErrCodeDes()));
        }
        return result;
    }
}

