/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.utils;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.XML;
import com.alibaba.fastjson.JSON;
import com.bizvane.message.component.BatchOperationMessage;
import com.bizvane.message.component.bean.BizvaneExceptionEnum;
import com.bizvane.message.component.bean.GuoduSmsSendResponse;
import com.bizvane.message.component.bean.MessageException;
import com.bizvane.message.utils.Constant;
import com.bizvane.message.utils.GuoduStatusEnum;
import com.bizvane.message.utils.StrongJsoup;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.text.StrSubstitutor;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class GuoduSmsUtil {
    private static final Logger log = LoggerFactory.getLogger(GuoduSmsUtil.class);
    private static final String GUODU_SMS_URL = "http://qxtsms.guodulink.net:8000/QxtSms/QxtFirewall";
    private static final String GUODU_SMS_URL_BATCH = "http://qxtsms.guodulink.net:8000/HttpQuickProcess/submitMessageAll";

    private static String replaceVariable(String templateContent, Map<String, String> param) {
        if (CollectionUtils.isEmpty(param)) {
            return templateContent;
        }
        StrSubstitutor sub = new StrSubstitutor(param);
        return sub.replace(templateContent);
    }

    public static GuoduSmsSendResponse sendVariableSms(Map<String, String> paramJson) {
        String urlParam = "http://qxtsms.guodulink.net:8000/HttpQuickProcess/submitMessageAll?" + Joiner.on((String)"&").useForNull("").withKeyValueSeparator("=").join(paramJson);
        log.info("\u8bf7\u6c42\u56fd\u90fd\u53d8\u91cf\u77ed\u4fe1\u53d1\u9001\u5e73\u53f0\u5165\u53c2:{}", (Object)urlParam);
        Document document = StrongJsoup.connect((String)urlParam).get();
        log.info("\u8bf7\u6c42\u56fd\u90fd\u53d8\u91cf\u77ed\u4fe1\u53d1\u9001\u5e73\u53f0\u8fd4\u56de\u53c2\u6570:{}", (Object)document.toString());
        GuoduSmsSendResponse res = new GuoduSmsSendResponse();
        String[] str = document.toString().split(",");
        String code = str[0];
        res.setCode(code);
        GuoduStatusEnum enumValue = GuoduStatusEnum.getStatusByCode((String)code);
        Assert.notNull((Object)enumValue, (String)"\u56fd\u90fd\u54cd\u5e94\u7684code\u5339\u914d\u4e0d\u5230\u679a\u4e3e\u503c");
        if (str.length == 1 && !enumValue.getStatus().equals(Constant.ONE)) {
            res.setErrorMsg(enumValue.getDesc());
            log.error("\u56fd\u90fd\u5e73\u53f0\u53d1\u9001\u77ed\u4fe1\u8fd4\u56deerror:\u5f02\u5e38\u7801\u662f:{},desc:{}", (Object)code, (Object)enumValue.getDesc());
        } else {
            res.setMsgId(str[1]);
        }
        return res;
    }

    public static GuoduSmsSendResponse sendSms(Map<String, String> paramJson) {
        String urlParam = "http://qxtsms.guodulink.net:8000/QxtSms/QxtFirewall?" + Joiner.on((String)"&").useForNull("").withKeyValueSeparator("=").join(paramJson);
        log.info("\u8bf7\u6c42\u56fd\u90fd\u77ed\u4fe1\u53d1\u9001\u5e73\u53f0\u5165\u53c2:{}", (Object)urlParam);
        Document document = StrongJsoup.connect((String)urlParam).get();
        log.info("\u8bf7\u6c42\u56fd\u90fd\u77ed\u4fe1\u53d1\u9001\u5e73\u53f0\u8fd4\u53c2:{}", (Object)document.toString());
        JSONObject json = XML.toJSONObject((String)document.toString());
        GuoduSmsSendResponse res = new GuoduSmsSendResponse();
        JSONObject response = json.getJSONObject((Object)"response");
        String code = response.getStr((Object)"code");
        log.info("code\u662f\uff1a{}", (Object)code);
        res.setCode(code);
        GuoduStatusEnum enmuValue = GuoduStatusEnum.getStatusByCode((String)code);
        Assert.notNull((Object)enmuValue, (String)"\u56fd\u90fd\u54cd\u5e94\u7684code\u5339\u914d\u4e0d\u5230\u679a\u4e3e\u503c");
        if (Constant.ONE.equals(enmuValue.getStatus())) {
            Object obj = response.get((Object)"message");
            if (obj instanceof JSONArray) {
                res.setMessages((JSONArray)obj);
            } else {
                JSONArray array = new JSONArray();
                array.add(obj);
                res.setMessages(array);
            }
        } else {
            res.setErrorMsg(enmuValue.getDesc());
        }
        return res;
    }

    public static Map<String, String> getParamMap(String accessKeyId, String secret, String templateContent, Map<String, String> param, String phones, String templateCode) throws UnsupportedEncodingException, MessageException {
        if (Splitter.on((String)",").splitToList((CharSequence)phones).size() >= 200) {
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.GUODU_SMS_PHONE_LENGTH_TOO_LONG.getErrCode()).errCodeDes(BizvaneExceptionEnum.GUODU_SMS_PHONE_LENGTH_TOO_LONG.getErrCode()).build();
        }
        String unencoded = GuoduSmsUtil.replaceVariable((String)templateContent, param);
        if (unencoded.length() >= 500) {
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.GUODU_SMS_CONTENT_TOO_LONG_ERROR.getErrCode()).errCodeDes(BizvaneExceptionEnum.GUODU_SMS_CONTENT_TOO_LONG_ERROR.getErrCodeDes()).build();
        }
        String content = URLEncoder.encode(unencoded, "GBK");
        return GuoduSmsUtil.commonRequest((String)accessKeyId, (String)secret, (String)content, (String)phones, null);
    }

    public static Map<String, String> getParamMap(String accessKeyId, String secret, String templateContent, List<BatchOperationMessage> list, List<String> phones, String templateCode) throws UnsupportedEncodingException, MessageException {
        if (phones.size() >= 500) {
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.GUODU_SMS_VARIABLE_PHONE_LENGTH_TOO_LONG.getErrCode()).errCodeDes(BizvaneExceptionEnum.GUODU_SMS_VARIABLE_PHONE_LENGTH_TOO_LONG.getErrCode()).build();
        }
        if (CollectionUtils.isEmpty(list)) {
            log.error("\u53d1\u9001\u53d8\u91cf\u77ed\u4fe1\uff0c\u53d8\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.MESSAGE_GATEWAY_REQUEST_PARAM_ERROR.getErrCode()).errCodeDes(BizvaneExceptionEnum.MESSAGE_GATEWAY_REQUEST_PARAM_ERROR.getErrCode()).build();
        }
        ArrayList<String> encodeList = new ArrayList<String>();
        HashMap<String, Long> lengthMap = new HashMap<String, Long>();
        int charLength = 0;
        for (BatchOperationMessage batchOperationMessage : list) {
            String unencode = GuoduSmsUtil.replaceVariable((String)templateContent, (Map)batchOperationMessage.getParams());
            charLength += unencode.length();
            long length = unencode.length() / Constant.MESSAGE_COUNT_LENGTH + Constant.ONE;
            lengthMap.put(batchOperationMessage.getPhone(), length);
            encodeList.add(URLEncoder.encode(unencode, "GBK"));
        }
        if (charLength >= 500) {
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.GUODU_SMS_CONTENT_TOO_LONG_ERROR.getErrCode()).errCodeDes(BizvaneExceptionEnum.GUODU_SMS_CONTENT_TOO_LONG_ERROR.getErrCodeDes()).build();
        }
        String content = (String)encodeList.get(0);
        if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty((Map)list.get(0).getParams())) {
            log.info("\u6279\u91cfencode");
            content = URLEncoder.encode(Joiner.on((String)",").useForNull("").join(encodeList), "GBK");
        }
        log.info("content:{}", (Object)content);
        return GuoduSmsUtil.commonRequest((String)accessKeyId, (String)secret, (String)content, (String)Joiner.on((String)",").useForNull("").join(phones), (String)JSON.toJSONString(lengthMap));
    }

    private static Map<String, String> commonRequest(String accessKeyId, String secret, String content, String phones, String length) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("OperID", accessKeyId);
        map.put("OperPass", secret);
        map.put("SendTime", "");
        map.put("ValidTime", "");
        map.put("AppendID", "");
        map.put("DesMobile", phones);
        map.put("Content", content);
        map.put("Content_Code", "0");
        map.put("length", StringUtils.isEmpty((Object)length) ? "" : length);
        return map;
    }
}

