/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.component;

import com.bizvane.base.common.bean.SmsReqBean;
import com.bizvane.message.component.annotation.SmsValid;
import com.bizvane.message.component.bean.MessageStrategyEnum;
import com.bizvane.message.utils.Constant;
import java.util.Collection;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SmsValidator
implements ConstraintValidator<SmsValid, SmsReqBean> {
    private static final Logger log = LoggerFactory.getLogger(SmsValidator.class);

    public boolean isValid(SmsReqBean value, ConstraintValidatorContext context) {
        log.info("\u81ea\u5b9a\u4e49\u6821\u9a8c\u8fdb\u5165");
        context.disableDefaultConstraintViolation();
        if (value == null) {
            context.buildConstraintViolationWithTemplate("\u4f60\u7684\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a").addConstraintViolation();
            return false;
        }
        String merchantId = value.getMerchantId();
        String type = value.getChannelType();
        String batchid = value.getBatchid();
        if (StringUtils.isBlank((CharSequence)batchid) || batchid.contains("_")) {
            context.buildConstraintViolationWithTemplate("batchid\u4e3a\u7a7a\u6216\u8005batchid\u5185\u542b\u6709\u975e\u6cd5\u5b57\u7b26'_'").addConstraintViolation();
            return false;
        }
        if (StringUtils.isBlank((CharSequence)merchantId)) {
            context.buildConstraintViolationWithTemplate("merchantid\u4e0d\u80fd\u4e3a\u7a7a").addConstraintViolation();
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)value.getPhones())) {
            context.buildConstraintViolationWithTemplate("\u53d1\u9001\u77ed\u4fe1\u7684\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a").addConstraintViolation();
            return false;
        }
        if (StringUtils.isBlank((CharSequence)MessageStrategyEnum.getStrategyByType((String)type))) {
            context.buildConstraintViolationWithTemplate("\u53d1\u9001\u77ed\u4fe1\u7684type\u4e0d\u5bf9").addConstraintViolation();
            return false;
        }
        if (StringUtils.isBlank((CharSequence)value.getTemplateCode())) {
            context.buildConstraintViolationWithTemplate("\u77ed\u4fe1\u6a21\u677fcode\u4e0d\u80fd\u4e3a\u7a7a").addConstraintViolation();
            return false;
        }
        if (value.getPhones().size() >= Constant.THOUSAND) {
            context.buildConstraintViolationWithTemplate("\u77ed\u4fe1\u7f51\u5173\u9ed8\u8ba4\u4e0d\u5141\u8bb8\u4e00\u6b21\u6027\u53d1\u9001\u8d85\u8fc71000\u6761\u77ed\u4fe1").addConstraintViolation();
            return false;
        }
        if (!CollectionUtils.isEmpty((Collection)value.getParams()) && value.getParams().size() > Constant.HUNDRED) {
            context.buildConstraintViolationWithTemplate("\u77ed\u4fe1\u7f51\u5173\u9ed8\u8ba4\u4e0d\u5141\u8bb8\u4e00\u6b21\u6027\u53d1\u9001\u8d85\u8fc7100\u6761\u7684\u53d8\u91cf\u77ed\u4fe1").addConstraintViolation();
            return false;
        }
        log.info("\u81ea\u5b9a\u4e49\u6821\u9a8c\u5b8c\u6210 \u6b64\u6b21\u5171\u6709:{}\u6761\u77ed\u4fe1", (Object)value.getPhones().size());
        return true;
    }
}

