/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.base.remote.service;

import com.bizvane.base.common.bean.ListResultBean;
import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.remote.dto.TemplateDto;
import javax.validation.constraints.NotBlank;
import org.hibernate.validator.constraints.Length;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="message-gateway-service", path="/message-gateway.api/message")
public interface IRemoteTemplateService {
    @RequestMapping(method={RequestMethod.POST}, value={"/createTemplate"}, produces={"application/json"})
    public ResultBean<TemplateDto> createTemplate(@RequestParam(value="merchantId") @NotBlank(message="merchantId not null") @NotBlank(message="merchantId not null") String var1, @RequestParam(value="channelType") @NotBlank(message="channelType not null") @NotBlank(message="channelType not null") String var2, @RequestParam(value="templateName") @NotBlank(message="templateName not null") @NotBlank(message="templateName not null") String var3, @RequestParam(value="templateType") @NotBlank(message="templateType not null") @NotBlank(message="templateType not null") String var4, @RequestParam(value="templateContent") @NotBlank(message="templateContent not null") @NotBlank(message="templateContent not null") String var5, @RequestParam(value="remark") @NotBlank(message="remark not null") @NotBlank(message="remark not null") String var6, @RequestParam(value="postFix", required=false) String var7, @RequestParam(value="sysCode") @Length(max=32) @NotBlank(message="sysCode not null") @Length(max=32) @NotBlank(message="sysCode not null") String var8, @RequestParam(value="signatures", required=false) String var9, @RequestParam(value="originalContent", required=false) String var10, @RequestParam(value="attach", required=false) @Length(max=255, message="\u9884\u7559\u5b57\u6bb5\u4e0d\u80fd\u8d85\u8fc7255\u4f4d") @Length(max=255, message="\u9884\u7559\u5b57\u6bb5\u4e0d\u80fd\u8d85\u8fc7255\u4f4d") String var11);

    @RequestMapping(method={RequestMethod.GET}, value={"/queryTemplate"}, produces={"application/json"})
    public ResultBean<TemplateDto> queryTemplate(@RequestParam(value="merchantId") @NotBlank(message="merchantId not null") @NotBlank(message="merchantId not null") String var1, @RequestParam(value="channelType") @NotBlank(message="channelType not null") @NotBlank(message="channelType not null") String var2, @RequestParam(value="templateCode") @NotBlank(message="templateCode not null") @NotBlank(message="templateCode not null") String var3);

    @RequestMapping(method={RequestMethod.GET}, value={"/queryTemplatePage"}, produces={"application/json"})
    public ListResultBean<TemplateDto> queryTemplatePage(@RequestParam(value="merchantId") @NotBlank(message="merchantId not null") @NotBlank(message="merchantId not null") String var1, @RequestParam(value="channelType") @NotBlank(message="channelType not null") @NotBlank(message="channelType not null") String var2, @RequestParam(value="templateCode", required=false) String var3, @RequestParam(value="templateType", required=false) String var4, @RequestParam(value="status", required=false) String var5, @RequestParam(value="templateName", required=false) String var6, @RequestParam(value="sysCode", required=false) String var7, @RequestParam(value="remark", required=false) String var8, @RequestParam(value="pageNum", defaultValue="0", required=false) Long var9, @RequestParam(value="pageSize", defaultValue="10", required=false) Long var10);

    @RequestMapping(method={RequestMethod.GET}, value={"/queryTemplatePageMultiMerchant"}, produces={"application/json"})
    public ListResultBean<TemplateDto> queryTemplatePageMultiMerchant(@RequestParam(value="merchantIds") String var1, @RequestParam(value="templateCode", required=false) String var2, @RequestParam(value="templateType", required=false) String var3, @RequestParam(value="status", required=false) String var4, @RequestParam(value="templateName", required=false) String var5, @RequestParam(value="sysCode", required=false) String var6, @RequestParam(value="remark", required=false) String var7, @RequestParam(value="pageNum", defaultValue="0", required=false) Long var8, @RequestParam(value="pageSize", defaultValue="10", required=false) Long var9);

    @RequestMapping(method={RequestMethod.GET}, value={"/getMerchantIdByTemplateCode"}, produces={"application/json"})
    public ResultBean<String> getMerchantIdByTemplateCode(@RequestParam(value="templateCode") String var1);
}

