package com.bizvane.messagefacade.models.vo.subscribe;

import com.alibaba.fastjson.annotation.JSONField;
import com.bizvane.messagefacade.models.vo.CouponMessageVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author yuantq
 * @date 2022/8/22
 */
@Data
public class CouponUseMessageVO extends CouponMessageVO {

    @JSONField(name = "FIELD_MEMBER_CARD_NO")
    @JsonProperty(value = "FIELD_MEMBER_CARD_NO")
    private String FIELD_MEMBER_CARD_NO;

    @JSONField(name = "FIELD_COUPON_NAME")
    @JsonProperty(value = "FIELD_COUPON_NAME")
    private String FIELD_COUPON_NAME;

    @JSONField(name = "FIELD_COUPON_DISCOUNT")
    @JsonProperty(value = "FIELD_COUPON_DISCOUNT")
    private BigDecimal FIELD_COUPON_DISCOUNT;

    /**
     * 优惠券有效期
     */
    @DateTimeFormat(pattern = "yyyy年MM月dd日 HH:mm:ss")
    @JsonFormat(pattern = "yyyy年MM月dd日 HH:mm:ss", timezone = "GMT+8")
    @JSONField(name = "FIELD_COUPON_VALID_DATE")
    @JsonProperty(value = "FIELD_COUPON_VALID_DATE")
    private Date FIELD_COUPON_VALID_DATE;

    @JSONField(name = "FIELD_COUPON_EXPLAIN")
    @JsonProperty(value = "FIELD_COUPON_EXPLAIN")
    private String FIELD_COUPON_EXPLAIN;

    @DateTimeFormat(pattern = "yyyy年MM月dd日 HH:mm:ss")
    @JsonFormat(pattern = "yyyy年MM月dd日 HH:mm:ss", timezone = "GMT+8")
    @JSONField(name = "FIELD_COUPON_USE_TIME")
    @JsonProperty(value = "FIELD_COUPON_USE_TIME")
    private Date FIELD_COUPON_USE_TIME;

    @JSONField(name = "FIELD_TEXT")
    @JsonProperty(value = "FIELD_TEXT")
    private String FIELD_TEXT;

}
