package com.bizvane.messagefacade.interfaces;

import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 获取微信模板
 * @author Bizvane
 */
@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/wxTemplateMag")
public interface WxTemplateMessageServiceFeign {

    /**
     * 查微信模板消息
     *
     * @param businessType
     * @return
     */
    @ApiOperation(value = "查询微信模板消息", notes = "查询微信模板消息", tags = {"微信模板查询"}, httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "sysBrandId", value = "所属品牌id", required = true, dataType = "Long"),
            @ApiImplicitParam(name = "templateType", value = "微信模板类型", required = true, dataType = "String")
    })
    @PostMapping("/getTemplateType")
    ResponseData<Object> getTemplate(@RequestParam("sysBrandId") Long sysBrandId,
                                     @RequestParam("businessType") String businessType,
                                     @RequestParam("templateType") String templateType);
}
