package com.bizvane.messagefacade.interfaces;

import com.bizvane.messagefacade.models.vo.AjhOrderMessageVO;
import com.bizvane.messagefacade.models.vo.MemberMessageVO;
import com.bizvane.messagefacade.models.vo.OrderMessageVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 奥佳华订单相关模板消息
 *
 */
@FeignClient(value = "${feign.client.message.name}", path = "${feign.client.message.path}/ajhOrder")
@Api(value = "奥佳华订单相关模板消息", tags = {"奥佳华订单相关模板消息"})
public interface AjhOrderServiceFeign {

	/**
	 * 服务评价提醒
	 *
	 * @param vo
	 * @return
	 */
	@ApiOperation(value = "服务评价提醒")
	@RequestMapping(value = "/orderCommentConsume", method = RequestMethod.POST)
	ResponseData<String> orderCommentConsume(@RequestBody(required = false) AjhOrderMessageVO vo);

	/**
	 * 师傅接单提醒
	 *
	 * @param vo
	 * @return
	 */
	@ApiOperation(value = "师傅接单提醒")
	@RequestMapping(value = "/masterAcceptOrder", method = RequestMethod.POST)
	ResponseData<String> masterAcceptOrder(@RequestBody(required = false) AjhOrderMessageVO vo);

	/**
	 * 发货通知
	 *
	 * @param vo
	 * @return
	 */
	@ApiOperation(value = "发货通知")
	@RequestMapping(value = "/orderShip", method = RequestMethod.POST)
	ResponseData<String> orderShip(@RequestBody(required = false) AjhOrderMessageVO vo);


	/**
	 * 预约成功通知
	 *
	 * @param vo
	 * @return
	 */
	@ApiOperation(value = "预约成功通知")
	@RequestMapping(value = "/appointmentSuccess", method = RequestMethod.POST)
	ResponseData<String> appointmentSuccess(@RequestBody(required = false) AjhOrderMessageVO vo);


}
