package com.bizvane.messagefacade.enums.subscribefield;

import com.bizvane.messagefacade.enums.WeChatSubscribeFieldEnum;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author yuantq
 * @date 2022/8/23
 */
public enum MemberSignFieldEnum {

    FIELD_1("MEMBER_SIGN", WeChatSubscribeFieldEnum.MEMBER_CARD_NO, "FIELD_MEMBER_CARD_NO", Boolean.TRUE),
    FIELD_2("MEMBER_SIGN", WeChatSubscribeFieldEnum.ACTIVITY_NAME, "FIELD_ACTIVITY_NAME", Boolean.TRUE),
    FIELD_3("MEMBER_SIGN", WeChatSubscribeFieldEnum.ACTIVITY_START_TIME, "FIELD_ACTIVITY_START_TIME"),
    FIELD_4("MEMBER_SIGN", WeChatSubscribeFieldEnum.ACTIVITY_AWARD, "FIELD_ACTIVITY_AWARD", Boolean.TRUE),
    FIELD_5("MEMBER_SIGN", WeChatSubscribeFieldEnum.ACTIVITY_EXPLAIN, "FIELD_ACTIVITY_EXPLAIN", Boolean.TRUE),
    FIELD_6("MEMBER_SIGN", WeChatSubscribeFieldEnum.TEXT, "FIELD_TEXT");

    private String menuCode;

    private WeChatSubscribeFieldEnum weChatSubscribeFieldEnum;

    private String jsonField;

    private Boolean mustNotNull = Boolean.FALSE;

    MemberSignFieldEnum(String menuCode, WeChatSubscribeFieldEnum weChatSubscribeFieldEnum, String jsonField) {
        this.menuCode = menuCode;
        this.weChatSubscribeFieldEnum = weChatSubscribeFieldEnum;
        this.jsonField = jsonField;
    }

    MemberSignFieldEnum(String menuCode, WeChatSubscribeFieldEnum weChatSubscribeFieldEnum, String jsonField, Boolean mustNotNull) {
        this.menuCode = menuCode;
        this.weChatSubscribeFieldEnum = weChatSubscribeFieldEnum;
        this.jsonField = jsonField;
        this.mustNotNull = mustNotNull;
    }

    public String getMenuCode() {
        return menuCode;
    }

    public WeChatSubscribeFieldEnum getWeChatSubscribeFieldEnum() {
        return weChatSubscribeFieldEnum;
    }

    public String getJsonField() {
        return jsonField;
    }

    public Boolean getMustNotNull() {
        return mustNotNull;
    }

    public static List<String> mustFieldList() {
        return Arrays.stream(MemberSignFieldEnum.values()).filter(e -> e.getMustNotNull()).map(MemberSignFieldEnum::getJsonField).collect(Collectors.toList());
    }

    public static Map<String, String> codeConvertJsonFieldMap() {
        return Arrays.stream(MemberSignFieldEnum.values()).collect(Collectors.toMap(e -> e.getWeChatSubscribeFieldEnum().getFieldCode(), MemberSignFieldEnum::getJsonField, (a, b) -> b));
    }

}
