package com.bizvane.messagefacade.enums;

/**
 * 短信模板类型 短信接口对应中控
 * @author Bizvane
 */
public enum SmsChannelTypeEnum {
    /**
     *   短信接口 模板类型,可选值: 0：验证码。 1：短信通知 2：推广短信。 3：国际/港澳台消息
     *  中控  '10=营销；20=验证码'
     */
    SMS_YZ(0, 20),
    SMS_TZ(2, 10);

    SmsChannelTypeEnum(Integer smsType, Integer centerType) {
        this.smsType = smsType;
        this.centerType = centerType;
    }

    private final Integer smsType;
    private final Integer centerType;

    public static Integer getCenterType(Integer type) {
        for (SmsChannelTypeEnum value : SmsChannelTypeEnum.values()) {
            if (value.smsType.equals(type)) {
                return value.centerType;
            }
        }
        return null;
    }
}
