package com.bizvane.messagefacade.models.vo.vg.subscribe;

import com.alibaba.fastjson.annotation.JSONField;
import com.bizvane.messagefacade.models.vo.MemberMessageVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 *
 * {@link com.bizvane.messagefacade.enums.vg.subscribefield.IntegralSeckillStartFieldEnum}
 */
@Data
public class IntegralSeckillStartMessageVO extends MemberMessageVO {

    @JSONField(name = "FIELD_MEMBER_CODE")
    @JsonProperty(value = "FIELD_MEMBER_CODE")
    private String FIELD_MEMBER_CODE;

    @JSONField(name = "FIELD_TEXT")
    @JsonProperty(value = "FIELD_TEXT")
    private String FIELD_TEXT;

    @JSONField(name = "FIELD_INTEGRAL_GOOD_NAME")
    @JsonProperty(value = "FIELD_INTEGRAL_GOOD_NAME")
    private String FIELD_INTEGRAL_GOOD_NAME;

    @JSONField(name = "INTEGRAL_SECKILL_PRICE")
    @JsonProperty(value = "INTEGRAL_SECKILL_PRICE")
    private BigDecimal INTEGRAL_SECKILL_PRICE;

    @JSONField(name = "INTEGRAL_GOOD_PRICE")
    @JsonProperty(value = "INTEGRAL_GOOD_PRICE")
    private BigDecimal INTEGRAL_GOOD_PRICE;

    /**
     * 此处时间
     */
    @DateTimeFormat(pattern = "yyyy年MM月dd日 HH:mm:ss")
    @JsonFormat(pattern = "yyyy年MM月dd日 HH:mm:ss", timezone = "GMT+8")
    @JSONField(name = "INTEGRAL_SECKILL_START_TIME")
    @JsonProperty(value = "INTEGRAL_SECKILL_START_TIME")
    private Date INTEGRAL_SECKILL_START_TIME;

    /**
     * 此处时间
     */
    @DateTimeFormat(pattern = "yyyy年MM月dd日 HH:mm:ss")
    @JsonFormat(pattern = "yyyy年MM月dd日 HH:mm:ss", timezone = "GMT+8")
    @JSONField(name = "INTEGRAL_SECKILL_END_TIME")
    @JsonProperty(value = "INTEGRAL_SECKILL_END_TIME")
    private Date INTEGRAL_SECKILL_END_TIME;
}
