package com.bizvane.messagefacade.enums.vg;

import java.util.HashMap;

public enum WechatSubscribeSentFailEnum {

    ERROR_40003("40003","ouser字段 openid 为空或者不正确"),
    ERROR_40037("40037","订阅模板 id 为空不正确"),
    ERROR_43101("43101","用户拒绝接受消息，如果用户之前曾经订阅过，则表示用户取消了订阅关系"),
    ERROR_47003("47003","模板参数不准确，可能为空或者不满足规则"),
    ERROR_41030("41030","page路径不正确，需要保证在现网版本小程序中存在，与 app.json 保持一致"),
    ;

    private String errcode;

    private String errmsg;

    WechatSubscribeSentFailEnum(String errcode, String errmsg) {
        this.errcode = errcode;
        this.errmsg = errmsg;
    }

    public String getErrmsg() {
        return errmsg;
    }

    public String getErrcode() {
        return errcode;
    }

    private static HashMap<String,String> codeMsgMap = new HashMap<>();

    public static HashMap<String, String> getCodeMsgMap() {
        return codeMsgMap;
    }
}
