package com.bizvane.members.feign.model.mq;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.List;

@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class MbrIntegralChangeMQ {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("变动类型1.支出,2.收入,3过期")
    private Integer changeWay;

    @ApiModelProperty("变更积分")
    private Integer changeIntegral;

    @ApiModelProperty("变动时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime changeDate;

    @ApiModelProperty("业务类型：枚举IntegralBusinessWayEnum，字典integral_business_way")
    private Integer businessWay;

    @ApiModelProperty("业务code，需要全局唯一")
    private String businessCode;

    @ApiModelProperty("会员积分余额")
    private Integer countIntegral;

}
