package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponEntityListRequestParam {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("券code")
    private String couponEntityCode;

    @ApiModelProperty("券名称")
    private String couponName;

    @ApiModelProperty("券号")
    private String couponNo;

    @ApiModelProperty("券定义编号")
    private String couponDefinitionCode;

    @ApiModelProperty("20-未使用，25-已过期，30-已核销")
    private Integer couponStatus;

    @ApiModelProperty("任务名称")
    private String sendBusinessName;

    @ApiModelProperty("会员手机号")
    private String phone;

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("优惠类型（1现金,2折扣,3兑换）")
    private Integer preferentialType;

    @ApiModelProperty("券使用订单号")
    private String useBusinessCode;

    @ApiModelProperty("核销商户编号")
    private String useMerchantNo;

    @ApiModelProperty("发放类型（10-开卡发券，15-会员生日，20-受赠，25-积分兑换，30-线上开卡，35-会员升级，--40-会员生日，45-会员消费，50-会员签到，55-领券，60-完善资料，65-微信分享，70-消费次数，75-消费金额，80-邀请开卡, 81-调查问卷,85-批量发券,90-入会纪念日,95-定向营销 ，100 - 评价奖励活动，101 - 积分商城，103大转盘，104红包膨胀，105-砸金蛋，106-宝宝生日活动，107-会员首单活动，108-摇一摇，109-储值送礼，110-预生成券，111-员工券，115 - 线下ERP发券，120 - 天猫券，125 - 线下领券 ,130-自动营销, 135-神策发放）")
    private List<Integer> sendTypeList;

    @ApiModelProperty("发券时间开始")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDateStart;

    @ApiModelProperty("发券时间结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDateEnd;

    @ApiModelProperty("核销时间开始")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime useTimeStart;

    @ApiModelProperty("核销时间结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime useTimeEnd;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("是否排除转赠中的券：true-排除，false-不排除。默认不排除")
    private Boolean excludeGiveStatus;

    private int pageNum = 1;

    private int pageSize  = 10;

}
